-----------------------------------------------------------------------
--         FILE:  xindex-cfg.lua
--  DESCRIPTION:  configuration file for xindex.lua
-- REQUIREMENTS:  
--       AUTHOR:  Herbert Voß
--      LICENSE:  LPPL1.3
--
-- $Id: xindex-danteedition.lua 6 2026-02-15 06:59:19Z herbert $
-----------------------------------------------------------------------

if not modules then modules = { } end modules ['xindex-cfg'] = {
      version = 1.04,
      comment = "configuration file for the DANTE Edition",
       author = "Herbert Voss",
    copyright = "Herbert Voss",
      license = "LPPL 1.3"
}

itemPageDelimiter = ","     -- Hello, 14
compressPages     = true    -- something like 12--15, instead of 12,13,14,15. the |( ... |) syntax is still valid
fCompress	      = true    -- 3f -> page 3, 4 and 3ff -> page 3, 4, 5
minCompress       = 3       -- 14--17 or 
rangeSymbol       = "--"
numericPage       = true    -- for non numerical pagenumbers, like "VI-17"
sublabels         = {"", "-\\,", "--\\,", "---\\,"} -- for the (sub(sub(sub-items  first one is for item
pageNoPrefixDel   = ""     -- a delimiter for page numbers like "VI-17"  -- not used !!!
indexOpening      = ""     -- commands after \begin{theindex}
idxnewletter      = "\\idxnewletter"  -- Only valid if -n is not set
envStart          = "\\begin{theindex}"  
envStop           = "\\end{theindex}"
language		  = "de"

--[[
    Each character's position in this array-like table determines its 'priority'.
    Several characters in the same slot have the same 'priority'.
]]

folium = { 
  cs = {"f.", "ff."},
  da = {"f", "ff"},
  de = {"f", "ff"},
  en = {"f", "ff"},
  es = {"f", "ff"},
  fr = {"\\,sq.","\\,sqq."},
  it = {"f", "ff"},
  jp = {"シンボル","番号"},
  nl = {"f.", "ff."},
  no = {"\\,f.","\\,ff."},
  ru = {"",""},       -- doesn't exist
}

